<?php
session_start();

// Proteção: apenas logados podem baixar o backup
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: login.php");
    exit;
}

require 'conexao.php';

// Busca todos os registros
$stmt = $pdo->query("SELECT * FROM consultas ORDER BY data_registro DESC");
$clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Define os cabeçalhos para forçar o download do arquivo CSV
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="backup_clientes_' . date('Y-m-d_H-i') . '.csv"');

// Abre a saída do PHP
$saida = fopen('php://output', 'w');

// Adiciona o BOM (Byte Order Mark) para o Excel ler acentos corretamente (UTF-8)
fputs($saida, "\xEF\xBB\xBF");

// Cabeçalho das colunas no Excel
$cabecalhos = ['ID', 'Nome', 'CPF', 'Telefone', 'Endereço', 'Profissão', 'Salário Base (R$)', 'Admissão', 'Demissão', 'Relato do Cliente', 'Motivo da Ação', 'Data do Registro'];
fputcsv($saida, $cabecalhos, ';');

// Preenche os dados linha por linha
foreach ($clientes as $cli) {
    // Formata as datas para o padrão brasileiro, se existirem
    $admissao = !empty($cli['data_admissao']) ? date('d/m/Y', strtotime($cli['data_admissao'])) : '';
    $demissao = !empty($cli['data_demissao']) ? date('d/m/Y', strtotime($cli['data_demissao'])) : '';
    $registro = !empty($cli['data_registro']) ? date('d/m/Y H:i', strtotime($cli['data_registro'])) : '';
    
    // Formata o salário
    $salario = !empty($cli['salario_base']) ? number_format((float)$cli['salario_base'], 2, ',', '.') : '';

    $linha = [
        $cli['id'],
        $cli['nome'],
        $cli['cpf'],
        $cli['telefone'],
        $cli['endereco'],
        $cli['profissao'],
        $salario,
        $admissao,
        $demissao,
        $cli['relato_cliente'],
        $cli['motivo_acao'],
        $registro
    ];
    
    // Escreve a linha no CSV separada por ponto e vírgula
    fputcsv($saida, $linha, ';');
}

fclose($saida);
exit;
?>