<?php
session_start();
// Verifica segurança
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: login.php");
    exit;
}
require 'conexao.php';

$mensagem = '';

// ==========================================
// 1. GERAR BACKUP DO BANCO DE DADOS (.SQL)
// ==========================================
if (isset($_GET['acao']) && $_GET['acao'] === 'download_db') {
    $tabela = 'consultas';
    $sql_dump = "-- Backup do Sistema Jurídico\n";
    $sql_dump .= "-- Gerado em: " . date('d/m/Y H:i:s') . "\n\n";
    $sql_dump .= "SET foreign_key_checks = 0;\n";
    $sql_dump .= "DROP TABLE IF EXISTS `$tabela`;\n";
    
    // Pega a estrutura da tabela
    $stmt = $pdo->query("SHOW CREATE TABLE `$tabela`");
    $row = $stmt->fetch(PDO::FETCH_NUM);
    $sql_dump .= $row[1] . ";\n\n";
    
    // Pega os dados
    $stmt = $pdo->query("SELECT * FROM `$tabela`");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $colunas = array_map(function($k) { return "`$k`"; }, array_keys($row));
        $valores = array_map(function($v) use ($pdo) {
            return ($v === null) ? 'NULL' : $pdo->quote($v);
        }, array_values($row));
        $sql_dump .= "INSERT INTO `$tabela` (" . implode(', ', $colunas) . ") VALUES (" . implode(', ', $valores) . ");\n";
    }
    $sql_dump .= "SET foreign_key_checks = 1;\n";

    // Força o download do arquivo .sql
    header('Content-Type: application/sql');
    header('Content-Disposition: attachment; filename="backup_banco_' . date('Y-m-d_H-i') . '.sql"');
    echo $sql_dump;
    exit;
}

// ==========================================
// 2. GERAR BACKUP DOS ARQUIVOS/ANEXOS (.ZIP)
// ==========================================
if (isset($_GET['acao']) && $_GET['acao'] === 'download_arquivos') {
    $diretorio = 'uploads/';
    $nome_zip = 'backup_anexos_' . date('Y-m-d_H-i') . '.zip';
    
    if (class_exists('ZipArchive')) {
        $zip = new ZipArchive();
        if ($zip->open($nome_zip, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
            if (is_dir($diretorio)) {
                $arquivos = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($diretorio));
                foreach ($arquivos as $nome => $arquivo) {
                    if (!$arquivo->isDir()) {
                        $caminho_real = $arquivo->getRealPath();
                        $caminho_relativo = substr($caminho_real, strlen(realpath($diretorio)) + 1);
                        $zip->addFile($caminho_real, $caminho_relativo);
                    }
                }
            }
            $zip->close();
            
            // Força o download do ZIP
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="' . $nome_zip . '"');
            header('Content-Length: ' . filesize($nome_zip));
            readfile($nome_zip);
            unlink($nome_zip); // Apaga o zip do servidor após o download
            exit;
        } else {
            $mensagem = "<div class='alert alert-danger'><i class='bi bi-x-circle'></i> Erro ao criar o arquivo ZIP.</div>";
        }
    } else {
        $mensagem = "<div class='alert alert-warning'><i class='bi bi-exclamation-triangle'></i> A extensão ZipArchive não está ativa no seu servidor PHP.</div>";
    }
}

// ==========================================
// 3. RESTAURAR BANCO DE DADOS (.SQL)
// ==========================================
if (isset($_POST['restaurar_db']) && isset($_FILES['arquivo_sql'])) {
    if ($_FILES['arquivo_sql']['error'] === UPLOAD_ERR_OK) {
        $extensao = strtolower(pathinfo($_FILES['arquivo_sql']['name'], PATHINFO_EXTENSION));
        
        if ($extensao === 'sql') {
            $conteudo_sql = file_get_contents($_FILES['arquivo_sql']['tmp_name']);
            try {
                // Executa as queries do backup (Isso apagará a tabela atual e recriará com os dados do backup)
                $pdo->exec($conteudo_sql);
                $mensagem = "<div class='alert alert-success shadow-sm'><i class='bi bi-check-circle-fill'></i> Banco de dados restaurado com sucesso!</div>";
            } catch (PDOException $e) {
                $mensagem = "<div class='alert alert-danger shadow-sm'><i class='bi bi-x-circle-fill'></i> Erro SQL: " . $e->getMessage() . "</div>";
            }
        } else {
            $mensagem = "<div class='alert alert-warning shadow-sm'><i class='bi bi-exclamation-triangle'></i> Por favor, envie apenas o arquivo .sql gerado pelo sistema.</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Gestão de Backups - Sistema Jurídico</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f4f7f6; }
        .navbar-adv { background: #0f2027; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
        .card-premium { border: none; border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); }
        .btn-gold { background-color: #d4af37; color: #fff; font-weight: 500; }
        .btn-gold:hover { background-color: #bfa033; color: white; }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark navbar-adv py-3">
    <div class="container">
        <span class="navbar-brand fw-bold h1 mb-0"><i class="bi bi-shield-check text-warning me-2"></i> Gestão de Backups</span>
        <div>
            <a href="admin.php" class="btn btn-light btn-sm rounded-pill px-3"><i class="bi bi-arrow-left"></i> Voltar ao Painel</a>
        </div>
    </div>
</nav>

<div class="container mt-5">
    <?= $mensagem ?>

    <div class="row g-4">
        <div class="col-md-6">
            <div class="card card-premium h-100">
                <div class="card-header bg-white border-bottom-0 pt-4 pb-2">
                    <h5 class="fw-bold text-dark"><i class="bi bi-cloud-arrow-down text-primary me-2"></i> Criar Cópia de Segurança</h5>
                    <p class="text-muted small">Baixe os dados e documentos do seu escritório periodicamente para segurança.</p>
                </div>
                <div class="card-body px-4 pb-4">
                    <div class="d-grid gap-3">
                        <a href="backup.php?acao=download_db" class="btn btn-outline-primary py-3 fw-bold text-start border-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <span><i class="bi bi-database me-2 fs-5"></i> 1. Baixar Banco de Dados (.SQL)</span>
                                <i class="bi bi-download fs-5"></i>
                            </div>
                        </a>
                        
                        <a href="backup.php?acao=download_arquivos" class="btn btn-outline-success py-3 fw-bold text-start border-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <span><i class="bi bi-file-earmark-zip me-2 fs-5"></i> 2. Baixar Documentos Anexos (.ZIP)</span>
                                <i class="bi bi-download fs-5"></i>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card card-premium h-100 border-danger" style="border-left: 4px solid #dc3545 !important;">
                <div class="card-header bg-white border-bottom-0 pt-4 pb-2">
                    <h5 class="fw-bold text-dark"><i class="bi bi-cloud-arrow-up text-danger me-2"></i> Restaurar Banco de Dados</h5>
                    <p class="text-muted small text-danger">Atenção: Restaurar um backup substituirá <strong>todas</strong> as fichas atuais do sistema pelas fichas contidas no arquivo.</p>
                </div>
                <div class="card-body px-4 pb-4">
                    <form method="POST" enctype="multipart/form-data" onsubmit="return confirm('ATENÇÃO: Isso apagará os dados de hoje e voltará o sistema para o momento em que o backup foi gerado. Deseja continuar?');">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Selecione o arquivo de Backup (.SQL)</label>
                            <input type="file" name="arquivo_sql" class="form-control" accept=".sql" required>
                        </div>
                        <button type="submit" name="restaurar_db" class="btn btn-danger w-100 fw-bold py-2"><i class="bi bi-arrow-counterclockwise me-2"></i> Restaurar Sistema</button>
                    </form>
                    
                    <hr class="mt-4 mb-3">
                    <p class="small text-muted mb-0"><i class="bi bi-info-circle me-1"></i> <strong>Nota sobre Documentos:</strong> Para restaurar os documentos (.ZIP), basta descompactar o arquivo baixado e enviar as pastas/fotos diretamente para a pasta <code>uploads/</code> no servidor usando seu painel de hospedagem (cPanel/FTP).</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>