<?php
require 'conexao.php';
$mensagem = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $arquivos_salvos = [];
    $erro_upload = false;

    // Lógica de Upload Múltiplo Seguro (Inalterada)
    if (isset($_FILES['documento']) && !empty($_FILES['documento']['name'][0])) {
        $total_arquivos = count($_FILES['documento']['name']);
        $permitidos = ['pdf', 'jpg', 'jpeg', 'png'];
        $diretorio = 'uploads/';
        if (!is_dir($diretorio)) mkdir($diretorio, 0755, true);

        for ($i = 0; $i < $total_arquivos; $i++) {
            if ($_FILES['documento']['error'][$i] === UPLOAD_ERR_OK) {
                $extensao = strtolower(pathinfo($_FILES['documento']['name'][$i], PATHINFO_EXTENSION));
                if (in_array($extensao, $permitidos)) {
                    $nome_base = pathinfo($_FILES['documento']['name'][$i], PATHINFO_FILENAME);
                    $nome_limpo = preg_replace('/[^A-Za-z0-9_]/', '', str_replace(' ', '_', $nome_base));
                    $nome_limpo = substr($nome_limpo, 0, 35);
                    $nome_novo = $nome_limpo . '_' . substr(uniqid(), -4) . '_' . $i . '.' . $extensao;
                    if (move_uploaded_file($_FILES['documento']['tmp_name'][$i], $diretorio . $nome_novo)) {
                        $arquivos_salvos[] = $diretorio . $nome_novo; 
                    }
                } else {
                    $erro_upload = true;
                    $mensagem = "<div class='alert alert-warning shadow-sm'><i class='bi bi-exclamation-triangle'></i> Um ou mais arquivos têm formato inválido.</div>";
                    break;
                }
            }
        }
    }

    if (!$erro_upload) {
        $json_arquivos = !empty($arquivos_salvos) ? json_encode($arquivos_salvos) : null;
        
        // Empacota toda a super ficha (array 'ficha') em formato JSON para salvar no banco
        $dados_entrevista = json_encode($_POST['ficha'] ?? [], JSON_UNESCAPED_UNICODE);

        // Salvamos os dados principais separados para busca, e o restante no JSON
        $sql = "INSERT INTO consultas (nome, cpf, telefone, arquivo, dados_entrevista) VALUES (?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        
        if ($stmt->execute([
            $_POST['ficha']['rec_nome'], 
            $_POST['ficha']['rec_cpf'], 
            $_POST['ficha']['rec_tel'], 
            $json_arquivos, 
            $dados_entrevista
        ])) {
            $mensagem = "<div class='alert alert-success shadow-sm'><i class='bi bi-check-circle'></i> Super Ficha registrada com sucesso!</div>";
        } else {
            $mensagem = "<div class='alert alert-danger shadow-sm'>Erro ao registrar.</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Entrevista Trabalhista Completa</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Poppins', sans-serif; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); min-height: 100vh; padding-bottom: 50px; }
        .bg-advogado { background: linear-gradient(135deg, #0f2027, #203a43, #2c5364); color: #fff; padding: 2rem; text-align: center; border-radius: 15px 15px 0 0; }
        .accordion-button:not(.collapsed) { background-color: #f8f9fa; color: #d4af37; font-weight: bold; box-shadow: inset 0 -1px 0 rgba(0,0,0,.125); }
        .form-label { font-size: 0.85rem; font-weight: 600; color: #555; margin-bottom: 0.2rem; }
        .form-control, .form-select { border-radius: 8px; font-size: 0.9rem; border: 1px solid #ccc; }
        .form-control:focus { border-color: #d4af37; box-shadow: 0 0 0 0.25rem rgba(212, 175, 55, 0.25); }
        .btn-gold { background-color: #d4af37; color: #fff; font-weight: 600; padding: 12px; border-radius: 10px; transition: 0.3s; }
        .btn-gold:hover { background-color: #bfa033; transform: translateY(-2px); color: white;}
        .section-title { font-size: 1.1rem; color: #2c5364; border-bottom: 2px solid #eee; padding-bottom: 5px; margin-bottom: 15px; margin-top: 15px; font-weight: bold; }
    </style>
</head>
<body>
<div class="container mt-4">
    <div class="card shadow-lg border-0" style="border-radius: 15px;">
        <div class="bg-advogado">
            <i class="bi bi-bank display-4 mb-2" style="color: #d4af37;"></i>
            <h3 class="fw-bold mb-0">Ficha de Entrevista Trabalhista</h3>
            <p class="text-light opacity-75 mt-1 mb-0">Preenchimento Completo</p>
        </div>
        <div class="card-body p-4 p-md-5">
            <?= $mensagem ?>
            
            <form method="POST" enctype="multipart/form-data">
                
                <div class="row mb-4">
                    <div class="col-md-4">
                        <label class="form-label">Data da Entrevista</label>
                        <input type="date" name="ficha[data_entrevista]" class="form-control" value="<?= date('Y-m-d') ?>">
                    </div>
                    <div class="col-md-8">
                        <label class="form-label">Advogado Responsável</label>
                        <input type="text" name="ficha[advogado_resp]" class="form-control" placeholder="Dr.(a)">
                    </div>
                </div>

                <div class="accordion mb-4 shadow-sm" id="accordionFicha">
                    
                    <div class="accordion-item border-0 border-bottom">
                        <h2 class="accordion-header"><button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1">1 & 2. Qualificação (Reclamante e Reclamada)</button></h2>
                        <div id="collapse1" class="accordion-collapse collapse show" data-bs-parent="#accordionFicha">
                            <div class="accordion-body bg-light">
                                <h6 class="section-title">1. RECLAMANTE</h6>
                                <div class="row g-2">
                                    <div class="col-md-8"><label class="form-label">Nome Completo *</label><input type="text" name="ficha[rec_nome]" class="form-control" required></div>
                                    <div class="col-md-4"><label class="form-label">Telefone *</label><input type="text" name="ficha[rec_tel]" class="form-control" required></div>
                                    <div class="col-md-3"><label class="form-label">CPF *</label><input type="text" name="ficha[rec_cpf]" class="form-control" required></div>
                                    <div class="col-md-3"><label class="form-label">RG</label><input type="text" name="ficha[rec_rg]" class="form-control"></div>
                                    <div class="col-md-3"><label class="form-label">Data Nasc.</label><input type="date" name="ficha[rec_nasc]" class="form-control"></div>
                                    <div class="col-md-3"><label class="form-label">Estado Civil</label><input type="text" name="ficha[rec_est_civil]" class="form-control"></div>
                                    <div class="col-md-8"><label class="form-label">Endereço (Rua)</label><input type="text" name="ficha[rec_end]" class="form-control"></div>
                                    <div class="col-md-2"><label class="form-label">Nº</label><input type="text" name="ficha[rec_num]" class="form-control"></div>
                                    <div class="col-md-2"><label class="form-label">CEP</label><input type="text" name="ficha[rec_cep]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Bairro</label><input type="text" name="ficha[rec_bairro]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Cidade</label><input type="text" name="ficha[rec_cidade]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Estado</label><input type="text" name="ficha[rec_uf]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Nacionalidade</label><input type="text" name="ficha[rec_nac]" class="form-control" value="Brasileira"></div>
                                    <div class="col-md-4"><label class="form-label">Profissão (Geral)</label><input type="text" name="ficha[rec_prof]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">E-mail</label><input type="email" name="ficha[rec_email]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">CTPS Nº</label><input type="text" name="ficha[rec_ctps]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Série CTPS</label><input type="text" name="ficha[rec_serie]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">PIS</label><input type="text" name="ficha[rec_pis]" class="form-control"></div>
                                </div>

                                <h6 class="section-title mt-4">2. RECLAMADA (Empresa)</h6>
                                <div class="row g-2">
                                    <div class="col-md-8"><label class="form-label">Razão Social / Nome</label><input type="text" name="ficha[emp_nome]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">CNPJ</label><input type="text" name="ficha[emp_cnpj]" class="form-control"></div>
                                    <div class="col-md-8"><label class="form-label">Endereço da Empresa</label><input type="text" name="ficha[emp_end]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Nº e Bairro</label><input type="text" name="ficha[emp_bairro]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Cidade / UF</label><input type="text" name="ficha[emp_cid_uf]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Telefone Empresa</label><input type="text" name="ficha[emp_tel]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Insc. Estadual</label><input type="text" name="ficha[emp_ie]" class="form-control"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0 border-bottom">
                        <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2">3 a 7. Contratos, Função e Desligamento</button></h2>
                        <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#accordionFicha">
                            <div class="accordion-body bg-light">
                                <h6 class="section-title">3. HISTÓRICO DE CONTRATOS</h6>
                                <?php for($c=1; $c<=3; $c++): // Reduzido visualmente para 3 para não poluir, mas pode mapear mais ?>
                                <div class="row g-2 mb-2">
                                    <div class="col-md-2 pt-2 fw-bold text-muted"><?= $c ?>º Contrato</div>
                                    <div class="col-md-5"><label class="form-label">Admissão</label><input type="date" name="ficha[cont_adm_<?= $c ?>]" class="form-control"></div>
                                    <div class="col-md-5"><label class="form-label">Demissão</label><input type="date" name="ficha[cont_dem_<?= $c ?>]" class="form-control"></div>
                                </div>
                                <?php endfor; ?>

                                <h6 class="section-title mt-4">4. REGISTRO & 7. FUNÇÃO</h6>
                                <div class="row g-2">
                                    <div class="col-md-6">
                                        <label class="form-label d-block">Trabalhou sem registro?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[sem_reg]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[sem_reg]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label d-block">Recebeu verbas do período sem registro?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_sem_reg]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_sem_reg]" value="Não"> Não</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_sem_reg]" value="Temos"> Temos Recibo</div>
                                    </div>
                                    <div class="col-md-6"><label class="form-label">Data Admissão Correta (Real)</label><input type="date" name="ficha[data_real_adm]" class="form-control"></div>
                                    <div class="col-md-6"><label class="form-label">Data Demissão Correta (Real)</label><input type="date" name="ficha[data_real_dem]" class="form-control"></div>
                                    <div class="col-md-12"><label class="form-label">7. Descreva detalhadamente suas funções na reclamada:</label><textarea name="ficha[desc_funcoes]" class="form-control" rows="3"></textarea></div>
                                </div>

                                <h6 class="section-title mt-4">6. DESLIGAMENTO</h6>
                                <div class="row g-2">
                                    <div class="col-md-12"><label class="form-label">Motivo (Justa causa, pedido, dispensa sem justa causa...)</label><input type="text" name="ficha[motivo_desligamento]" class="form-control"></div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Sindicância Interna?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[sindicancia]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[sindicancia]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Assinou carta?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[assinou_carta]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[assinou_carta]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Recebeu carta via correio?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[carta_correio]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[carta_correio]" value="Não"> Não</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0 border-bottom">
                        <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3">8 a 13. Jornada de Trabalho e Horas Extras</button></h2>
                        <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#accordionFicha">
                            <div class="accordion-body bg-light">
                                <h6 class="section-title">8. HORÁRIOS CUMPRIDOS</h6>
                                <div class="row g-2">
                                    <div class="col-md-6">
                                        <label class="form-label">1º Período de Trabalho (Dias da semana, Ex: Seg a Sex)</label><input type="text" name="ficha[periodo_1]" class="form-control">
                                        <div class="d-flex gap-2 mt-1">
                                            <input type="time" name="ficha[hora_ent_1]" class="form-control" title="Entrada"> 
                                            <span class="pt-1">às</span> 
                                            <input type="time" name="ficha[hora_sai_1]" class="form-control" title="Saída">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">2º Período (Caso houvesse mudança ou sábado)</label><input type="text" name="ficha[periodo_2]" class="form-control">
                                        <div class="d-flex gap-2 mt-1">
                                            <input type="time" name="ficha[hora_ent_2]" class="form-control"> 
                                            <span class="pt-1">às</span> 
                                            <input type="time" name="ficha[hora_sai_2]" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6 mt-3"><label class="form-label">Intervalo de Descanso / Refeição</label>
                                        <div class="d-flex gap-2"><input type="time" name="ficha[int_ent]" class="form-control"> às <input type="time" name="ficha[int_sai]" class="form-control"></div>
                                    </div>
                                    <div class="col-md-6 mt-3">
                                        <label class="form-label d-block">Havia Controle de Ponto?</label>
                                        <select class="form-select" name="ficha[controle_ponto]">
                                            <option value="">Selecione...</option>
                                            <option value="Não havia">Não havia</option>
                                            <option value="Biométrico">Sim, Biométrico</option>
                                            <option value="Cartão/Crachá">Sim, Cartão/Crachá</option>
                                            <option value="Livro Manual">Sim, Livro Manual</option>
                                            <option value="Aplicativo">Sim, Aplicativo/Web</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mt-2">
                                        <label class="form-label d-block">O espelho/cartão era fiel à realidade?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[ponto_fiel]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[ponto_fiel]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-6 mt-2">
                                        <label class="form-label d-block">Trabalhava domingos e feriados?</label>
                                        <div class="d-flex gap-2">
                                            <select class="form-select" name="ficha[trab_domingo]">
                                                <option value="Não">Não</option>
                                                <option value="Sim">Sim</option>
                                            </select>
                                            <input type="text" name="ficha[freq_domingo]" class="form-control" placeholder="Qts vezes/mês?">
                                        </div>
                                    </div>
                                </div>

                                <h6 class="section-title mt-4">12. HORAS EXTRAS</h6>
                                <div class="row g-2">
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Fazia horas extras e não recebia?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[he_nao_paga]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[he_nao_paga]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Pagas em folha (Holerite)?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[he_folha]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[he_folha]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Pagas "Por Fora" (Recibo apartado)?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[he_por_fora]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[he_por_fora]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-12"><label class="form-label">Desde quando não recebe horas extras?</label><input type="text" name="ficha[he_data_falha]" class="form-control"></div>
                                    <div class="col-md-12 mt-2"><label class="form-label">9/10. Descreva rotina e chefias:</label><textarea name="ficha[rotina_chefia]" class="form-control" rows="2"></textarea></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0 border-bottom">
                        <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4">14 a 17 e 21. Remuneração, Férias e Benefícios</button></h2>
                        <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#accordionFicha">
                            <div class="accordion-body bg-light">
                                <h6 class="section-title">14 e 15. REMUNERAÇÃO BASE E 13º</h6>
                                <div class="row g-2">
                                    <div class="col-md-4"><label class="form-label">Último Salário (R$)</label><input type="number" step="0.01" name="ficha[ultimo_salario]" class="form-control"></div>
                                    <div class="col-md-4"><label class="form-label">Comissão de (R$ ou %)</label><input type="text" name="ficha[comissao]" class="form-control"></div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Pagamento era em dia?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[pag_em_dia]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[pag_em_dia]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-12 mt-2">
                                        <label class="form-label fw-bold">Adicionais Percebidos (Marque os que recebia):</label><br>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Insalubridade"> <label>Insalubridade</label></div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Periculosidade"> <label>Periculosidade</label></div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Noturno"> <label>Noturno</label></div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Sobreaviso"> <label>Sobreaviso</label></div>
                                    </div>
                                    <div class="col-md-6 mt-3">
                                        <label class="form-label d-block">Recebeu 13º todo o período?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_13]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_13]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-6 mt-3"><label class="form-label">Qual período faltou do 13º?</label><input type="text" name="ficha[falta_13]" class="form-control"></div>
                                </div>

                                <h6 class="section-title mt-4">16 e 17. BENEFÍCIOS</h6>
                                <div class="row g-2">
                                    <div class="col-md-6">
                                        <label class="form-label d-block">A empresa pagava/entregava Vale-Transporte?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_vt]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[recebeu_vt]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-6"><label class="form-label">Custo Diário Passagem (R$)</label><input type="text" name="ficha[custo_vt]" class="form-control"></div>
                                    <div class="col-md-6 mt-2">
                                        <label class="form-label d-block">Fornecia Convênio Médico?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[convenio]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[convenio]" value="Não"> Não</div>
                                    </div>
                                </div>

                                <h6 class="section-title mt-4">21. FÉRIAS</h6>
                                <div class="row g-2">
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Gozou todas as férias?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[gozou_ferias]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[gozou_ferias]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label d-block">Trabalhou durante férias?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[trab_ferias]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[trab_ferias]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4"><label class="form-label">Qual período ficou sem receber?</label><input type="text" name="ficha[ferias_nao_pagas]" class="form-control"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0">
                        <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5">18 a 25. Saúde, EPI, Verbas Rescisórias</button></h2>
                        <div id="collapse5" class="accordion-collapse collapse" data-bs-parent="#accordionFicha">
                            <div class="accordion-body bg-light">
                                <h6 class="section-title">18 e 19. INSALUBRIDADE E EPI</h6>
                                <div class="row g-2">
                                    <div class="col-md-12"><label class="form-label">Contato nocivo (Fumaça, Ruído, Poeira, Inflamável, etc.):</label><input type="text" name="ficha[agentes_nocivos]" class="form-control" placeholder="Descreva os agentes..."></div>
                                    <div class="col-md-4 mt-2">
                                        <label class="form-label d-block">Fornecia EPI?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[fornecia_epi]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[fornecia_epi]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4 mt-2">
                                        <label class="form-label d-block">EPIs possuíam C.A?</label>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[epi_ca]" value="Sim"> Sim</div>
                                        <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="ficha[epi_ca]" value="Não"> Não</div>
                                    </div>
                                    <div class="col-md-4 mt-2"><label class="form-label">Reposição do EPI:</label><input type="text" name="ficha[reposicao_epi]" class="form-control" placeholder="De quanto em quanto tempo?"></div>
                                </div>
                                
                                <h6 class="section-title mt-4">20. ESTABILIDADE (Marque e descreva se aplicável)</h6>
                                <div class="row g-2">
                                    <div class="col-md-12"><label class="form-label">Estabilidade por Gestação, CIPA, Acidente ou Sindicato?</label><textarea name="ficha[estabilidade_desc]" class="form-control" rows="2" placeholder="Ex: Gestante de X semanas, ou Acidente em DD/MM..."></textarea></div>
                                </div>

                                <h6 class="section-title mt-4">22. VERBAS RESCISÓRIAS (O que NÃO recebeu?)</h6>
                                <div class="row g-2 text-muted small">
                                    <div class="col-md-4">
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Multa Art 477"><label>Multa do Art. 477</label></div>
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Aviso Prévio"><label>Aviso Prévio</label></div>
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Saldo de Salário"><label>Saldo de salário</label></div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="13 Salário"><label>13º Salário Proporcional</label></div>
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Férias Proporcionais"><label>Férias Proporcionais + 1/3</label></div>
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Férias Vencidas"><label>Férias Vencidas</label></div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="FGTS 40%"><label>Multa 40% FGTS</label></div>
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Horas Extras"><label>Horas extras não pagas</label></div>
                                        <div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Guias Seguro/TRCT"><label>Guias (Seguro/TRCT)</label></div>
                                    </div>
                                </div>

                                <div class="col-md-12 mt-3"><label class="form-label">O FGTS foi depositado corretamente? Período faltante:</label><input type="text" name="ficha[fgts_falta]" class="form-control"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="p-4 rounded-3 mb-4" style="background-color: #f8f9fa; border: 1px dashed #ced4da;">
                    <label class="fw-semibold mb-2"><i class="bi bi-paperclip me-2"></i>Anexar Documentos (CTPS, RG, Holerites, Provas)</label>
                    <input type="file" name="documento[]" class="form-control" accept=".pdf, .jpg, .jpeg, .png" multiple>
                    <small class="text-muted mt-1 d-block">Pode selecionar múltiplos. Máx 2MB por arquivo.</small>
                </div>

                <button type="submit" class="btn btn-gold w-100 fs-5 shadow-sm"><i class="bi bi-send-fill me-2"></i>Registrar Super Ficha</button>

            </form>
        </div>
    </div>
    
    <div class="text-center mt-4">
        <a href="login.php" class="text-muted text-decoration-none px-3 py-2 rounded-pill" style="font-size: 0.9rem; transition: all 0.3s; opacity: 0.7;">
            <i class="bi bi-shield-lock me-1"></i> Área do Advogado
        </a>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>