<?php
session_start();
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) { header("Location: login.php"); exit; }
require 'conexao.php';

$mensagem_painel = '';

// 1. ATUALIZAR TESE / PARECER
if (isset($_POST['atualizar_motivo'])) {
    $stmt = $pdo->prepare("UPDATE consultas SET motivo_acao = ? WHERE id = ?");
    $stmt->execute([$_POST['motivo_acao'], $_POST['id']]);
    $mensagem_painel = "<div class='alert alert-success shadow-sm container mt-4'><i class='bi bi-check-circle'></i> Parecer atualizado.</div>";
}

// 2. EDITAR FICHA COMPLETA (SEM PERDER DADOS - USANDO ARRAY_MERGE)
if (isset($_POST['editar_ficha_completa'])) {
    $id_ficha = $_POST['id_ficha'];
    
    // Pega os dados que já existem no banco primeiro para não perder nada
    $stmt = $pdo->prepare("SELECT dados_entrevista FROM consultas WHERE id = ?");
    $stmt->execute([$id_ficha]);
    $json_antigo = $stmt->fetchColumn();
    $array_antigo = json_decode($json_antigo, true) ?: [];
    
    // Mescla o antigo com o que veio do formulário de edição (o novo substitui o velho, o resto é mantido)
    $array_novo = array_merge($array_antigo, $_POST['ficha'] ?? []);
    
    $dados_entrevista = json_encode($array_novo, JSON_UNESCAPED_UNICODE);
    
    $sql = "UPDATE consultas SET nome=?, cpf=?, telefone=?, dados_entrevista=? WHERE id=?";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([
        $_POST['ficha']['rec_nome'], 
        $_POST['ficha']['rec_cpf'], 
        $_POST['ficha']['rec_tel'], 
        $dados_entrevista, 
        $id_ficha
    ])) {
        $mensagem_painel = "<div class='alert alert-success shadow-sm container mt-4'><i class='bi bi-pencil-square'></i> Ficha atualizada com sucesso. Nenhuma informação foi perdida!</div>";
    }
}

// 3. ADICIONAR ANEXOS
if (isset($_POST['adicionar_anexos']) && isset($_FILES['novos_documentos'])) {
    $id_ficha = $_POST['id_ficha'];
    $stmt = $pdo->prepare("SELECT arquivo FROM consultas WHERE id = ?");
    $stmt->execute([$id_ficha]);
    $atual = $stmt->fetchColumn();
    $arquivos_existentes = !empty($atual) ? json_decode($atual, true) : [];
    if (!is_array($arquivos_existentes)) $arquivos_existentes = [$atual];

    $diretorio = 'uploads/';
    $permitidos = ['pdf', 'jpg', 'jpeg', 'png'];
    $novos_salvos = [];
    $total_arquivos = count($_FILES['novos_documentos']['name']);
    
    for ($i = 0; $i < $total_arquivos; $i++) {
        if ($_FILES['novos_documentos']['error'][$i] === UPLOAD_ERR_OK) {
            $extensao = strtolower(pathinfo($_FILES['novos_documentos']['name'][$i], PATHINFO_EXTENSION));
            if (in_array($extensao, $permitidos)) {
                $nome_base = pathinfo($_FILES['novos_documentos']['name'][$i], PATHINFO_FILENAME);
                $nome_limpo = preg_replace('/[^A-Za-z0-9_]/', '', str_replace(' ', '_', $nome_base));
                $nome_novo = substr($nome_limpo, 0, 35) . '_' . substr(uniqid(), -4) . '_' . $i . '.' . $extensao;
                if (move_uploaded_file($_FILES['novos_documentos']['tmp_name'][$i], $diretorio . $nome_novo)) {
                    $novos_salvos[] = $diretorio . $nome_novo;
                }
            }
        }
    }
    if (count($novos_salvos) > 0) {
        $todos_arquivos = array_merge($arquivos_existentes, $novos_salvos);
        $stmt = $pdo->prepare("UPDATE consultas SET arquivo = ? WHERE id = ?");
        $stmt->execute([json_encode($todos_arquivos), $id_ficha]);
        $mensagem_painel = "<div class='alert alert-success shadow-sm container mt-4'><i class='bi bi-paperclip'></i> Novos anexos adicionados.</div>";
    }
}

// 4. REMOVER ANEXO
if (isset($_POST['remover_anexo'])) {
    $id_ficha = $_POST['id_ficha'];
    $caminho_remover = $_POST['caminho_anexo'];
    $stmt = $pdo->prepare("SELECT arquivo FROM consultas WHERE id = ?");
    $stmt->execute([$id_ficha]);
    $atual = $stmt->fetchColumn();
    if (!empty($atual)) {
        $arq_ext = json_decode($atual, true);
        if (!is_array($arq_ext)) $arq_ext = [$atual];
        if (($key = array_search($caminho_remover, $arq_ext)) !== false) {
            unset($arq_ext[$key]);
            if (file_exists($caminho_remover)) unlink($caminho_remover);
            $stmt = $pdo->prepare("UPDATE consultas SET arquivo = ? WHERE id = ?");
            $stmt->execute([empty($arq_ext) ? null : json_encode(array_values($arq_ext)), $id_ficha]);
            $mensagem_painel = "<div class='alert alert-success shadow-sm container mt-4'><i class='bi bi-trash'></i> Anexo removido.</div>";
        }
    }
}

// 5. ELIMINAR FICHA
if (isset($_POST['eliminar_ficha'])) {
    $id_eliminar = $_POST['id_eliminar'];
    $stmt = $pdo->prepare("SELECT arquivo FROM consultas WHERE id = ?");
    $stmt->execute([$id_eliminar]);
    $ficha_apagar = $stmt->fetchColumn();
    if (!empty($ficha_apagar)) {
        $arq_apg = json_decode($ficha_apagar, true);
        if (!is_array($arq_apg)) $arq_apg = [$ficha_apagar];
        foreach ($arq_apg as $arq) { if (file_exists($arq)) unlink($arq); }
    }
    $pdo->prepare("DELETE FROM consultas WHERE id = ?")->execute([$id_eliminar]);
    $mensagem_painel = "<div class='alert alert-success shadow-sm container mt-4'><i class='bi bi-trash-fill'></i> Ficha eliminada.</div>";
}

// BUSCA
$busca = $_GET['busca'] ?? '';
if (!empty($busca)) {
    $stmt = $pdo->prepare("SELECT * FROM consultas WHERE nome LIKE ? OR cpf LIKE ? ORDER BY data_registro DESC");
    $stmt->execute(["%$busca%", "%$busca%"]);
    $clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    $clientes = $pdo->query("SELECT * FROM consultas ORDER BY data_registro DESC")->fetchAll(PDO::FETCH_ASSOC);
}

// FUNÇÕES DE IMPRESSÃO
function chk($val, $expected) { return ($val === $expected) ? '( X )' : '( &nbsp;&nbsp; )'; }
function chkArr($arr, $val) { return (is_array($arr) && in_array($val, $arr)) ? '( X )' : '( &nbsp;&nbsp; )'; }
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel do Advogado</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { background-color: #f4f7f6; font-family: sans-serif; }
        .navbar-adv { background: #0f2027; }
        .card-client { border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); margin-bottom: 30px; }
        .info-box { background: #f8f9fa; border-left: 4px solid #d4af37; padding: 15px; border-radius: 0 8px 8px 0; margin-bottom: 15px; height: 100%; }
        .info-title { font-size: 0.85rem; text-transform: uppercase; font-weight: 700; color: #6c757d; margin-bottom: 10px; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
        .anexo-item { border: 1px solid #dee2e6; border-radius: 8px; padding: 8px 12px; display: inline-flex; align-items: center; background: #fff; margin: 4px; }
        .print-only { display: none; }
        
        /* Modal Edit Ajustes */
        .accordion-button:not(.collapsed) { background-color: #f8f9fa; color: #d4af37; font-weight: bold; }
        .modal-body label { color: #555; margin-bottom: 2px; margin-top: 8px; }

        /* ESTILOS DE IMPRESSÃO (DOCUMENTO FORMAL) */
        @media print {
            .no-print, .navbar-adv, .card-client, .modal, .alert { display: none !important; }
            body { background: white !important; font-family: 'Times New Roman', Times, serif !important; font-size: 11pt !important; margin: 0; padding: 0; }
            .print-only { display: none !important; }
            .print-only.print-active { display: block !important; color: black !important; padding: 1cm; }
            
            .doc-header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 20px; }
            .doc-title { text-align: center; font-size: 13pt; font-weight: bold; text-decoration: underline; margin-bottom: 20px; }
            
            .sec-title { font-weight: bold; margin-top: 5px; margin-bottom: 5px; font-size: 11pt; text-transform: uppercase; }
            .doc-row { line-height: 1.6; margin-bottom: 3px; }
            
            .sig-area { margin-top: 50px; text-align: center; page-break-inside: avoid; }
            .sig-line { width: 300px; border-top: 1px solid #000; margin: 0 auto; margin-bottom: 5px; }
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark navbar-adv no-print py-3">
    <div class="container">
        <span class="navbar-brand fw-bold h1 mb-0"><img src="logo2.png" alt="Logo do Escritório" style="max-height: 50px; margin-bottom: 15px;"> Sistema Jurídico</span>
        <div>
            <a href="index.php" class="btn btn-warning btn-sm me-2 rounded-pill px-3 text-dark fw-bold" style="background-color: #d4af37;"><i class="bi bi-plus-circle"></i> Nova Ficha</a>
            
            <a href="backup.php" class="btn btn-outline-info btn-sm me-2 rounded-pill px-3"><i class="bi bi-shield-lock"></i> Backups</a>
            
            <a href="exportar_csv.php" class="btn btn-outline-warning btn-sm me-2 rounded-pill px-3"><i class="bi bi-file-earmark-excel"></i> CSV</a>
            <a href="logout.php" class="btn btn-light btn-sm rounded-pill px-3">Sair</a>
        </div>
    </div>
</nav>

<?= $mensagem_painel ?>

<div class="container mt-4 no-print">
    <div class="card card-client mb-4">
        <div class="card-body p-4">
            <form method="GET" class="row g-2 align-items-center">
                <div class="col-md-9"><input type="text" name="busca" class="form-control" placeholder="Buscar por Nome ou CPF..." value="<?= htmlspecialchars($busca) ?>"></div>
                <div class="col-md-3 d-flex gap-2"><button type="submit" class="btn btn-dark w-100">Pesquisar</button><a href="admin.php" class="btn btn-outline-secondary w-100">Limpar</a></div>
            </form>
        </div>
    </div>
    <?php if (count($clientes) === 0): ?><div class="alert alert-info text-center">Nenhuma ficha encontrada.</div><?php endif; ?>
</div>

<?php foreach ($clientes as $cli): 
    $f = json_decode($cli['dados_entrevista'] ?? '{}', true);
    if(!is_array($f)) $f = []; 

    $arq_cli = [];
    if (!empty($cli['arquivo'])) {
        $dec = json_decode($cli['arquivo'], true);
        $arq_cli = is_array($dec) ? $dec : [$cli['arquivo']];
    }
?>

<div class="container no-print">
    <div class="card card-client">
        <div class="card-header bg-white d-flex justify-content-between align-items-center pt-3 pb-3">
            <h5 class="fw-bold mb-0 text-dark"><i class="bi bi-person-circle text-secondary me-2"></i> <?= htmlspecialchars($cli['nome']) ?></h5>
            <div class="d-flex gap-2">
                <button type="button" class="btn btn-sm btn-outline-primary rounded-pill px-3" data-bs-toggle="modal" data-bs-target="#modalEditar<?= $cli['id'] ?>"><i class="bi bi-pencil"></i> Editar Ficha Completa</button>
                <button type="button" onclick="imprimirFichaEspecífica('<?= $cli['id'] ?>')" class="btn btn-sm btn-dark rounded-pill px-3"><i class="bi bi-printer"></i> Imprimir Entrevista</button>
                <form method="POST" onsubmit="return confirm('Tem certeza absoluta de que deseja excluir esta ficha e TODOS os anexos?');" class="m-0">
                    <input type="hidden" name="id_eliminar" value="<?= $cli['id'] ?>">
                    <button type="submit" name="eliminar_ficha" class="btn btn-sm btn-outline-danger rounded-pill"><i class="bi bi-trash"></i></button>
                </form>
            </div>
        </div>
        
        <div class="card-body px-4 pb-4">
            <div class="row mt-2 g-3">
                <div class="col-md-4"><div class="info-box"><div class="info-title">Reclamante</div><strong>CPF:</strong> <?= htmlspecialchars($cli['cpf']) ?><br><strong>Tel:</strong> <?= htmlspecialchars($cli['telefone']) ?><br><strong>Nasc:</strong> <?= !empty($f['rec_nasc']) ? date('d/m/Y', strtotime($f['rec_nasc'])) : '--' ?></div></div>
                <div class="col-md-4"><div class="info-box"><div class="info-title">Reclamada</div><strong>Empresa:</strong> <?= htmlspecialchars($f['emp_nome'] ?? '--') ?><br><strong>CNPJ:</strong> <?= htmlspecialchars($f['emp_cnpj'] ?? '--') ?><br><strong>Cidade:</strong> <?= htmlspecialchars($f['emp_cid_uf'] ?? '--') ?></div></div>
                <div class="col-md-4"><div class="info-box"><div class="info-title">Contrato Base</div><strong>Admissão:</strong> <?= !empty($f['cont_adm_1']) ? date('d/m/Y', strtotime($f['cont_adm_1'])) : '--' ?><br><strong>Demissão:</strong> <?= !empty($f['cont_dem_1']) ? date('d/m/Y', strtotime($f['cont_dem_1'])) : '--' ?><br><strong>Função:</strong> <?= htmlspecialchars($f['desc_funcoes'] ?? '--') ?></div></div>
            </div>

            <div class="mt-3 p-3 rounded border" style="background-color: #fcfcfc;">
                <h6 class="fw-bold mb-3"><i class="bi bi-folder2-open text-primary"></i> Provas e Documentos Anexados</h6>
                <?php if (!empty($arq_cli)): ?>
                    <div class="mb-3">
                        <?php foreach($arq_cli as $arq): ?>
                            <div class="anexo-item shadow-sm"><a href="<?= htmlspecialchars($arq) ?>" target="_blank" class="text-decoration-none me-3 fw-medium text-dark"><i class="bi bi-file-earmark-text text-danger"></i> <?= htmlspecialchars(basename($arq)) ?></a>
                            <form method="POST" class="m-0" onsubmit="return confirm('Apagar arquivo do servidor?');"><input type="hidden" name="id_ficha" value="<?= $cli['id'] ?>"><input type="hidden" name="caminho_anexo" value="<?= htmlspecialchars($arq) ?>"><button type="submit" name="remover_anexo" class="btn btn-sm btn-danger py-0 px-2 rounded-circle"><i class="bi bi-x"></i></button></form></div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form method="POST" enctype="multipart/form-data" class="d-flex align-items-center gap-2"><input type="hidden" name="id_ficha" value="<?= $cli['id'] ?>"><input type="file" name="novos_documentos[]" class="form-control form-control-sm w-auto" multiple required><button type="submit" name="adicionar_anexos" class="btn btn-sm btn-success"><i class="bi bi-upload"></i> Adicionar Provas</button></form>
            </div>

            <form method="POST" class="mt-4"><input type="hidden" name="id" value="<?= $cli['id'] ?>"><label class="fw-bold mb-1 text-primary"><i class="bi bi-hammer me-1"></i> Tese / Motivo Principal da Ação</label><div class="input-group"><input type="text" name="motivo_acao" class="form-control" value="<?= htmlspecialchars($cli['motivo_acao'] ?? '') ?>" placeholder="Tese..."><button class="btn btn-dark px-4">Salvar Tese</button></div></form>
        </div>
    </div>
</div>

<div class="print-only print-page" id="print-ficha-<?= $cli['id'] ?>">
    <div class="doc-header" style="text-align: center; border-bottom: 2px solid #000; padding-bottom: 5px; margin-bottom: 5px;">
        <img src="logo1.png" alt="Logo do Escritório" style="max-height: 90px; margin-bottom: 5px;">
        <p style="font-size: 9pt; color: #666; margin-top: 5px;">Av. Japão, 250, Sala 102 - Cariru - Ipatinga MG | Contato: (31) 98569-0232</p>
        <h2>ENTREVISTA TRABALHISTA</h2>
    </div>
    
    <div class="doc-row">
        <strong>Data:</strong> <?= !empty($f['data_entrevista']) ? date('d/m/Y', strtotime($f['data_entrevista'])) : '___/___/_____' ?>
        <strong style="margin-left:40px;">Responsável: Dr.(a)</strong> <?= htmlspecialchars($f['advogado_resp'] ?? '____________________') ?>
    </div>

    <div class="sec-title">1. RECLAMANTE:</div>
    <div class="doc-row"><strong>Nome:</strong> <?= htmlspecialchars($cli['nome']) ?> &nbsp;&nbsp;&nbsp; <strong>Telefone:</strong> <?= htmlspecialchars($cli['telefone']) ?></div>
    <div class="doc-row"><strong>Endereço:</strong> <?= htmlspecialchars($f['rec_end'] ?? '') ?> <strong>Nº:</strong> <?= htmlspecialchars($f['rec_num'] ?? '') ?> &nbsp;&nbsp;&nbsp; <strong>Bairro:</strong> <?= htmlspecialchars($f['rec_bairro'] ?? '') ?></div>
    <div class="doc-row"><strong>Cidade:</strong> <?= htmlspecialchars($f['rec_cidade'] ?? '') ?> <strong>Estado:</strong> <?= htmlspecialchars($f['rec_uf'] ?? '') ?> <strong>CEP:</strong> <?= htmlspecialchars($f['rec_cep'] ?? '') ?></div>
    <div class="doc-row"><strong>Nacionalidade:</strong> <?= htmlspecialchars($f['rec_nac'] ?? '') ?> &nbsp;&nbsp;&nbsp; <strong>Estado Civil:</strong> <?= htmlspecialchars($f['rec_est_civil'] ?? '') ?></div>
    <div class="doc-row"><strong>Profissão:</strong> <?= htmlspecialchars($f['rec_prof'] ?? '') ?> &nbsp;&nbsp;&nbsp; <strong>Data Nasc:</strong> <?= !empty($f['rec_nasc']) ? date('d/m/Y', strtotime($f['rec_nasc'])) : '' ?></div>
    <div class="doc-row"><strong>RG:</strong> <?= htmlspecialchars($f['rec_rg'] ?? '') ?> &nbsp;&nbsp;&nbsp; <strong>CPF:</strong> <?= htmlspecialchars($cli['cpf']) ?></div>
    <div class="doc-row"><strong>CTPS Nº:</strong> <?= htmlspecialchars($f['rec_ctps'] ?? '') ?> <strong>Série:</strong> <?= htmlspecialchars($f['rec_serie'] ?? '') ?> <strong>PIS:</strong> <?= htmlspecialchars($f['rec_pis'] ?? '') ?></div>
    <div class="doc-row"><strong>E-mail:</strong> <?= htmlspecialchars($f['rec_email'] ?? '') ?></div>

    <div class="sec-title">2. RECLAMADA:</div>
    <div class="doc-row"><strong>Nome:</strong> <?= htmlspecialchars($f['emp_nome'] ?? '') ?> &nbsp;&nbsp;&nbsp; <strong>Telefone:</strong> <?= htmlspecialchars($f['emp_tel'] ?? '') ?></div>
    <div class="doc-row"><strong>Endereço:</strong> <?= htmlspecialchars($f['emp_end'] ?? '') ?> <strong>Bairro:</strong> <?= htmlspecialchars($f['emp_bairro'] ?? '') ?></div>
    <div class="doc-row"><strong>Cidade/UF:</strong> <?= htmlspecialchars($f['emp_cid_uf'] ?? '') ?></div>
    <div class="doc-row"><strong>CNPJ:</strong> <?= htmlspecialchars($f['emp_cnpj'] ?? '') ?> &nbsp;&nbsp;&nbsp; <strong>Inscrição Est:</strong> <?= htmlspecialchars($f['emp_ie'] ?? '') ?></div>

    <div class="sec-title">3. CONTRATOS:</div>
    <div class="doc-row">
        1º Contrato - Adm: <?= !empty($f['cont_adm_1']) ? date('d/m/Y', strtotime($f['cont_adm_1'])) : '___/___/____' ?> | Dem: <?= !empty($f['cont_dem_1']) ? date('d/m/Y', strtotime($f['cont_dem_1'])) : '___/___/____' ?><br>
        2º Contrato - Adm: <?= !empty($f['cont_adm_2']) ? date('d/m/Y', strtotime($f['cont_adm_2'])) : '___/___/____' ?> | Dem: <?= !empty($f['cont_dem_2']) ? date('d/m/Y', strtotime($f['cont_dem_2'])) : '___/___/____' ?><br>
        3º Contrato - Adm: <?= !empty($f['cont_adm_3']) ? date('d/m/Y', strtotime($f['cont_adm_3'])) : '___/___/____' ?> | Dem: <?= !empty($f['cont_dem_3']) ? date('d/m/Y', strtotime($f['cont_dem_3'])) : '___/___/____' ?>
    </div>

    <div class="sec-title">4. REGISTRO:</div>
    <div class="doc-row">Trabalhou sem registro? <?= chk($f['sem_reg']??'', 'Sim') ?> Sim <?= chk($f['sem_reg']??'', 'Não') ?> Não</div>
    <div class="doc-row">Data de admissão correta: <?= !empty($f['data_real_adm']) ? date('d/m/Y', strtotime($f['data_real_adm'])) : '___/___/____' ?> &nbsp;&nbsp;&nbsp; Data demissão correta: <?= !empty($f['data_real_dem']) ? date('d/m/Y', strtotime($f['data_real_dem'])) : '___/___/____' ?></div>
    <div class="doc-row">Recebeu verbas relativas ao período sem registro? <?= chk($f['recebeu_sem_reg']??'', 'Sim') ?> Sim <?= chk($f['recebeu_sem_reg']??'', 'Não') ?> Não <?= chk($f['recebeu_sem_reg']??'', 'Temos') ?> Temos Recibo</div>

    <div class="sec-title">5. LOCAL DE TRABALHO:</div>
    <div class="doc-row">Rua/Avenida: <?= htmlspecialchars($f['local_trab'] ?? '') ?></div>

    <div class="sec-title">6. DESLIGAMENTO:</div>
    <div class="doc-row">Motivo: <?= htmlspecialchars($f['motivo_desligamento'] ?? '') ?></div>
    <div class="doc-row">Houve sindicância interna? <?= chk($f['sindicancia']??'', 'Sim') ?> Sim <?= chk($f['sindicancia']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Assinou carta? <?= chk($f['assinou_carta']??'', 'Sim') ?> Sim <?= chk($f['assinou_carta']??'', 'Não') ?> Não</div>
    <div class="doc-row">Recebeu alguma carta via correio? <?= chk($f['carta_correio']??'', 'Sim') ?> Sim <?= chk($f['carta_correio']??'', 'Não') ?> Não</div>

    <div class="sec-title">7. FUNÇÕES E 8/9/10. ROTINA E CHEFIA:</div>
    <div class="doc-row">Descreva detalhadamente suas funções: <?= htmlspecialchars($f['desc_funcoes'] ?? '') ?></div>
    <div class="doc-row">Descreva horários e rotina / Nome Chefia: <?= htmlspecialchars($f['rotina_chefia'] ?? '') ?></div>

    <div class="sec-title">11. JORNADA DE TRABALHO:</div>
    <div class="doc-row">1º Período: <?= htmlspecialchars($f['periodo_1'] ?? '') ?> - Das <?= htmlspecialchars($f['hora_ent_1'] ?? '') ?> às <?= htmlspecialchars($f['hora_sai_1'] ?? '') ?></div>
    <div class="doc-row">2º Período: <?= htmlspecialchars($f['periodo_2'] ?? '') ?> - Das <?= htmlspecialchars($f['hora_ent_2'] ?? '') ?> às <?= htmlspecialchars($f['hora_sai_2'] ?? '') ?></div>
    <div class="doc-row">Intervalo descanso: Das <?= htmlspecialchars($f['int_ent'] ?? '') ?> às <?= htmlspecialchars($f['int_sai'] ?? '') ?></div>
    <div class="doc-row">Trabalhava domingos e feriados? <?= chk($f['trab_domingo']??'', 'Sim') ?> Sim <?= chk($f['trab_domingo']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Quantas vezes/mês? <?= htmlspecialchars($f['freq_domingo'] ?? '') ?></div>
    <div class="doc-row">Havia controle de ponto? <?= chk($f['controle_ponto']??'', 'Sim') ?> Sim <?= chk($f['controle_ponto']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Qual? <?= htmlspecialchars($f['controle_ponto'] ?? '') ?></div>
    <div class="doc-row">O espelho/cartão era fiel? <?= chk($f['ponto_fiel']??'', 'Sim') ?> Sim <?= chk($f['ponto_fiel']??'', 'Não') ?> Não</div>

    <div class="sec-title">12. HORAS EXTRAS:</div>
    <div class="doc-row">Pagas em folhas normal? <?= chk($f['he_folha']??'', 'Sim') ?> Sim <?= chk($f['he_folha']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Em recibos apartados? <?= chk($f['he_por_fora']??'', 'Sim') ?> Sim <?= chk($f['he_por_fora']??'', 'Não') ?> Não</div>
    <div class="doc-row">Fazia H.E e não recebia? <?= chk($f['he_nao_paga']??'', 'Sim') ?> Sim <?= chk($f['he_nao_paga']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Desde quando não recebe? <?= htmlspecialchars($f['he_data_falha'] ?? '') ?></div>

    <div class="sec-title">14. REMUNERAÇÃO E BENEFÍCIOS:</div>
    <div class="doc-row">Qual foi o último salário? R$ <?= htmlspecialchars($f['ultimo_salario'] ?? '') ?> &nbsp;&nbsp;&nbsp; Comissão de: <?= htmlspecialchars($f['comissao'] ?? '') ?></div>
    <div class="doc-row">Pagamento em dia? <?= chk($f['pag_em_dia']??'', 'Sim') ?> Sim <?= chk($f['pag_em_dia']??'', 'Não') ?> Não</div>
    <div class="doc-row">Percebia adicional? 
        Insalubridade <?= chkArr($f['adicionais']??[], 'Insalubridade') ?> &nbsp; 
        Periculosidade <?= chkArr($f['adicionais']??[], 'Periculosidade') ?> &nbsp; 
        Sobreaviso <?= chkArr($f['adicionais']??[], 'Sobreaviso') ?> &nbsp; 
        Noturno <?= chkArr($f['adicionais']??[], 'Noturno') ?>
    </div>
    <div class="doc-row">Recebeu 13º todo período? <?= chk($f['recebeu_13']??'', 'Sim') ?> Sim <?= chk($f['recebeu_13']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Período faltante: <?= htmlspecialchars($f['falta_13'] ?? '') ?></div>
    <div class="doc-row">Pagava V.T corretamente? <?= chk($f['recebeu_vt']??'', 'Sim') ?> Sim <?= chk($f['recebeu_vt']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Custo: R$ <?= htmlspecialchars($f['custo_vt'] ?? '') ?></div>
    <div class="doc-row">Fornecia Convênio Médico? <?= chk($f['convenio']??'', 'Sim') ?> Sim <?= chk($f['convenio']??'', 'Não') ?> Não</div>

    <div class="sec-title">18/19. INSALUBRIDADE, PERICULOSIDADE E EPI:</div>
    <div class="doc-row">Laborava com nocivo (Fumaça, Ruído, etc)? <?= htmlspecialchars($f['agentes_nocivos'] ?? '') ?></div>
    <div class="doc-row">Fornecia EPI? <?= chk($f['fornecia_epi']??'', 'Sim') ?> Sim <?= chk($f['fornecia_epi']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; EPIs possuíam C.A? <?= chk($f['epi_ca']??'', 'Sim') ?> Sim <?= chk($f['epi_ca']??'', 'Não') ?> Não</div>
    <div class="doc-row">Frequência de reposição: <?= htmlspecialchars($f['reposicao_epi'] ?? '') ?></div>

    <div class="sec-title">20. ESTABILIDADE E 21. FÉRIAS:</div>
    <div class="doc-row">Estabilidade (Gestante, CIPA, Acidente): <?= htmlspecialchars($f['estabilidade_desc'] ?? '_________________________________') ?></div>
    <div class="doc-row">Gozou todas as férias? <?= chk($f['gozou_ferias']??'', 'Sim') ?> Sim <?= chk($f['gozou_ferias']??'', 'Não') ?> Não &nbsp;&nbsp;&nbsp; Trabalhou nas férias? <?= chk($f['trab_ferias']??'', 'Sim') ?> Sim <?= chk($f['trab_ferias']??'', 'Não') ?> Não</div>
    <div class="doc-row">Ficou sem receber alguma? Qual período? <?= htmlspecialchars($f['ferias_nao_pagas'] ?? '') ?></div>

    <div class="sec-title">22. VERBAS RESCISÓRIAS:</div>
    <div class="doc-row">O que não recebeu? <?= isset($f['verbas_devidas']) ? implode(', ', (array)$f['verbas_devidas']) : '______________' ?></div>
    <div class="doc-row">FGTS depositado corretamente? Período faltante: <?= htmlspecialchars($f['fgts_falta'] ?? '') ?></div>

    <div class="sig-area">
        <div class="doc-row" style="text-align: left; margin-bottom: 50px;">Local, ______ de ______________________ de 20____.</div>
        <div class="sig-line"></div>
        <strong><?= htmlspecialchars($cli['nome']) ?></strong><br>
        <span style="font-size: 9pt;">Reconheço como corretas as informações constantes neste formulário.</span>
    </div>
</div>

<div class="modal fade no-print" id="modalEditar<?= $cli['id'] ?>" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-dark text-white"><h5 class="modal-title"><i class="bi bi-pencil-square"></i> Editar Ficha: <?= htmlspecialchars($cli['nome']) ?></h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
            <div class="modal-body bg-light p-0">
                <form method="POST" class="p-3">
                    <input type="hidden" name="id_ficha" value="<?= $cli['id'] ?>">
                    
                    <div class="accordion" id="accEdit<?= $cli['id'] ?>">
                        <div class="accordion-item">
                            <h2 class="accordion-header"><button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#editCol1<?= $cli['id'] ?>">1. Qualificação (Reclamante e Reclamada)</button></h2>
                            <div id="editCol1<?= $cli['id'] ?>" class="accordion-collapse collapse show" data-bs-parent="#accEdit<?= $cli['id'] ?>">
                                <div class="accordion-body">
                                    <div class="row g-2">
                                        <div class="col-md-3"><label class="small fw-bold">Data Entrevista</label><input type="date" name="ficha[data_entrevista]" class="form-control form-control-sm" value="<?= $f['data_entrevista'] ?? '' ?>"></div>
                                        <div class="col-md-9"><label class="small fw-bold">Advogado Responsável</label><input type="text" name="ficha[advogado_resp]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['advogado_resp'] ?? '') ?>"></div>
                                        <div class="col-12 border-top mt-2"></div>
                                        <div class="col-md-6"><label class="small fw-bold">Nome Reclamante</label><input type="text" name="ficha[rec_nome]" class="form-control form-control-sm" value="<?= htmlspecialchars($cli['nome']) ?>" required></div>
                                        <div class="col-md-3"><label class="small fw-bold">CPF</label><input type="text" name="ficha[rec_cpf]" class="form-control form-control-sm" value="<?= htmlspecialchars($cli['cpf']) ?>" required></div>
                                        <div class="col-md-3"><label class="small fw-bold">Telefone</label><input type="text" name="ficha[rec_tel]" class="form-control form-control-sm" value="<?= htmlspecialchars($cli['telefone']) ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">RG</label><input type="text" name="ficha[rec_rg]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_rg'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Data Nasc.</label><input type="date" name="ficha[rec_nasc]" class="form-control form-control-sm" value="<?= $f['rec_nasc'] ?? '' ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Estado Civil</label><input type="text" name="ficha[rec_est_civil]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_est_civil'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Nacionalidade</label><input type="text" name="ficha[rec_nac]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_nac'] ?? '') ?>"></div>
                                        <div class="col-md-5"><label class="small fw-bold">Rua</label><input type="text" name="ficha[rec_end]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_end'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Nº</label><input type="text" name="ficha[rec_num]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_num'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">CEP</label><input type="text" name="ficha[rec_cep]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_cep'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Bairro</label><input type="text" name="ficha[rec_bairro]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_bairro'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Cidade</label><input type="text" name="ficha[rec_cidade]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_cidade'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">UF</label><input type="text" name="ficha[rec_uf]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_uf'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Profissão</label><input type="text" name="ficha[rec_prof]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_prof'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">E-mail</label><input type="email" name="ficha[rec_email]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_email'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">CTPS Nº</label><input type="text" name="ficha[rec_ctps]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_ctps'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Série CTPS</label><input type="text" name="ficha[rec_serie]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_serie'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">PIS</label><input type="text" name="ficha[rec_pis]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['rec_pis'] ?? '') ?>"></div>
                                        <div class="col-12 border-top mt-3 pt-2"></div>
                                        <div class="col-md-6"><label class="small fw-bold">Nome Empresa Reclamada</label><input type="text" name="ficha[emp_nome]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['emp_nome'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">CNPJ</label><input type="text" name="ficha[emp_cnpj]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['emp_cnpj'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Telefone Empresa</label><input type="text" name="ficha[emp_tel]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['emp_tel'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Endereço Emp.</label><input type="text" name="ficha[emp_end]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['emp_end'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Bairro Emp.</label><input type="text" name="ficha[emp_bairro]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['emp_bairro'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Cidade/UF Emp.</label><input type="text" name="ficha[emp_cid_uf]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['emp_cid_uf'] ?? '') ?>"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#editCol2<?= $cli['id'] ?>">2. Contratos, Registro e Desligamento</button></h2>
                            <div id="editCol2<?= $cli['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#accEdit<?= $cli['id'] ?>">
                                <div class="accordion-body">
                                    <div class="row g-2">
                                        <div class="col-md-3"><label class="small fw-bold">1º Admissão</label><input type="date" name="ficha[cont_adm_1]" class="form-control form-control-sm" value="<?= $f['cont_adm_1'] ?? '' ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">1º Demissão</label><input type="date" name="ficha[cont_dem_1]" class="form-control form-control-sm" value="<?= $f['cont_dem_1'] ?? '' ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">2º Admissão</label><input type="date" name="ficha[cont_adm_2]" class="form-control form-control-sm" value="<?= $f['cont_adm_2'] ?? '' ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">2º Demissão</label><input type="date" name="ficha[cont_dem_2]" class="form-control form-control-sm" value="<?= $f['cont_dem_2'] ?? '' ?>"></div>
                                        
                                        <div class="col-md-3"><label class="small fw-bold">Trabalhou sem Registro?</label><select class="form-select form-select-sm" name="ficha[sem_reg]"><option value="Não" <?= ($f['sem_reg']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['sem_reg']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>
                                        <div class="col-md-3"><label class="small fw-bold">Recebeu verbas do período sem reg?</label><select class="form-select form-select-sm" name="ficha[recebeu_sem_reg]"><option value="Não" <?= ($f['recebeu_sem_reg']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['recebeu_sem_reg']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Temos" <?= ($f['recebeu_sem_reg']??'')=='Temos'?'selected':'' ?>>Temos Recibo</option></select></div>
                                        <div class="col-md-3"><label class="small fw-bold">Data Adm. Correta (Real)</label><input type="date" name="ficha[data_real_adm]" class="form-control form-control-sm" value="<?= $f['data_real_adm'] ?? '' ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Data Dem. Correta (Real)</label><input type="date" name="ficha[data_real_dem]" class="form-control form-control-sm" value="<?= $f['data_real_dem'] ?? '' ?>"></div>

                                        <div class="col-md-4"><label class="small fw-bold">Motivo Desligamento</label><input type="text" name="ficha[motivo_desligamento]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['motivo_desligamento'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Houve Sindicância?</label><select class="form-select form-select-sm" name="ficha[sindicancia]"><option value="Não" <?= ($f['sindicancia']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['sindicancia']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>
                                        <div class="col-md-4"><label class="small fw-bold">Assinou carta?</label><select class="form-select form-select-sm" name="ficha[assinou_carta]"><option value="Não" <?= ($f['assinou_carta']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['assinou_carta']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>
                                        
                                        <div class="col-md-12"><label class="small fw-bold">7. Descreva detalhadamente as Funções</label><textarea name="ficha[desc_funcoes]" class="form-control form-control-sm" rows="2"><?= htmlspecialchars($f['desc_funcoes'] ?? '') ?></textarea></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#editCol3<?= $cli['id'] ?>">3. Jornada de Trabalho e Horas Extras</button></h2>
                            <div id="editCol3<?= $cli['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#accEdit<?= $cli['id'] ?>">
                                <div class="accordion-body">
                                    <div class="row g-2">
                                        <div class="col-md-4"><label class="small fw-bold">1º Período (Ex: Seg a Sex)</label><input type="text" name="ficha[periodo_1]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['periodo_1'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Entrada 1</label><input type="time" name="ficha[hora_ent_1]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['hora_ent_1'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Saída 1</label><input type="time" name="ficha[hora_sai_1]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['hora_sai_1'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Int. Entrada</label><input type="time" name="ficha[int_ent]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['int_ent'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Int. Saída</label><input type="time" name="ficha[int_sai]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['int_sai'] ?? '') ?>"></div>

                                        <div class="col-md-4"><label class="small fw-bold">2º Período (Ex: Sábado)</label><input type="text" name="ficha[periodo_2]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['periodo_2'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Entrada 2</label><input type="time" name="ficha[hora_ent_2]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['hora_ent_2'] ?? '') ?>"></div>
                                        <div class="col-md-2"><label class="small fw-bold">Saída 2</label><input type="time" name="ficha[hora_sai_2]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['hora_sai_2'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Havia Controle de Ponto?</label><input type="text" name="ficha[controle_ponto]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['controle_ponto'] ?? '') ?>" placeholder="Ex: Sim, Biométrico"></div>

                                        <div class="col-md-3"><label class="small fw-bold">O Ponto era Fiel?</label><select class="form-select form-select-sm" name="ficha[ponto_fiel]"><option value="Não" <?= ($f['ponto_fiel']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['ponto_fiel']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>
                                        <div class="col-md-3"><label class="small fw-bold">Trabalhava Domingos?</label><select class="form-select form-select-sm" name="ficha[trab_domingo]"><option value="Não" <?= ($f['trab_domingo']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['trab_domingo']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>
                                        <div class="col-md-6"><label class="small fw-bold">Fazia Horas Extras e Não Recebia?</label><select class="form-select form-select-sm" name="ficha[he_nao_paga]"><option value="Não" <?= ($f['he_nao_paga']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['he_nao_paga']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>

                                        <div class="col-md-12"><label class="small fw-bold">8/9. Descreva Horários, Rotina e Chefia</label><textarea name="ficha[rotina_chefia]" class="form-control form-control-sm" rows="2"><?= htmlspecialchars($f['rotina_chefia'] ?? '') ?></textarea></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#editCol4<?= $cli['id'] ?>">4. Remuneração, Benefícios e Férias</button></h2>
                            <div id="editCol4<?= $cli['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#accEdit<?= $cli['id'] ?>">
                                <div class="accordion-body">
                                    <div class="row g-2">
                                        <div class="col-md-3"><label class="small fw-bold">Último Salário (R$)</label><input type="number" step="0.01" name="ficha[ultimo_salario]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['ultimo_salario'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Comissão de:</label><input type="text" name="ficha[comissao]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['comissao'] ?? '') ?>"></div>
                                        <div class="col-md-3"><label class="small fw-bold">Pagamento em dia?</label><select class="form-select form-select-sm" name="ficha[pag_em_dia]"><option value="Sim" <?= ($f['pag_em_dia']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Não" <?= ($f['pag_em_dia']??'')=='Não'?'selected':'' ?>>Não</option></select></div>
                                        <div class="col-md-3"><label class="small fw-bold">Recebeu 13º todo período?</label><select class="form-select form-select-sm" name="ficha[recebeu_13]"><option value="Sim" <?= ($f['recebeu_13']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Não" <?= ($f['recebeu_13']??'')=='Não'?'selected':'' ?>>Não</option></select></div>
                                        
                                        <div class="col-md-12">
                                            <label class="small fw-bold d-block">Adicionais Percebidos:</label>
                                            <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Insalubridade" <?= in_array('Insalubridade', $f['adicionais']??[])?'checked':'' ?>> <label class="small">Insalubridade</label></div>
                                            <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Periculosidade" <?= in_array('Periculosidade', $f['adicionais']??[])?'checked':'' ?>> <label class="small">Periculosidade</label></div>
                                            <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Noturno" <?= in_array('Noturno', $f['adicionais']??[])?'checked':'' ?>> <label class="small">Noturno</label></div>
                                            <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ficha[adicionais][]" value="Sobreaviso" <?= in_array('Sobreaviso', $f['adicionais']??[])?'checked':'' ?>> <label class="small">Sobreaviso</label></div>
                                        </div>

                                        <div class="col-md-4"><label class="small fw-bold">Recebia Vale-Transporte?</label><select class="form-select form-select-sm" name="ficha[recebeu_vt]"><option value="Sim" <?= ($f['recebeu_vt']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Não" <?= ($f['recebeu_vt']??'')=='Não'?'selected':'' ?>>Não</option></select></div>
                                        <div class="col-md-4"><label class="small fw-bold">Custo Diário Passagem (R$)</label><input type="text" name="ficha[custo_vt]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['custo_vt'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Fornecia Convênio Médico?</label><select class="form-select form-select-sm" name="ficha[convenio]"><option value="Não" <?= ($f['convenio']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['convenio']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>

                                        <div class="col-md-4"><label class="small fw-bold">Gozou todas as Férias?</label><select class="form-select form-select-sm" name="ficha[gozou_ferias]"><option value="Sim" <?= ($f['gozou_ferias']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Não" <?= ($f['gozou_ferias']??'')=='Não'?'selected':'' ?>>Não</option></select></div>
                                        <div class="col-md-4"><label class="small fw-bold">Trabalhou nas Férias?</label><select class="form-select form-select-sm" name="ficha[trab_ferias]"><option value="Não" <?= ($f['trab_ferias']??'')=='Não'?'selected':'' ?>>Não</option><option value="Sim" <?= ($f['trab_ferias']??'')=='Sim'?'selected':'' ?>>Sim</option></select></div>
                                        <div class="col-md-4"><label class="small fw-bold">Férias não pagas (Período)</label><input type="text" name="ficha[ferias_nao_pagas]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['ferias_nao_pagas'] ?? '') ?>"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item">
                            <h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#editCol5<?= $cli['id'] ?>">5. Saúde, EPI e Verbas Rescisórias</button></h2>
                            <div id="editCol5<?= $cli['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#accEdit<?= $cli['id'] ?>">
                                <div class="accordion-body">
                                    <div class="row g-2">
                                        <div class="col-md-12"><label class="small fw-bold">Agentes Nocivos (Fumaça, Ruído, Poeira...)</label><input type="text" name="ficha[agentes_nocivos]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['agentes_nocivos'] ?? '') ?>"></div>
                                        <div class="col-md-4"><label class="small fw-bold">Fornecia EPI?</label><select class="form-select form-select-sm" name="ficha[fornecia_epi]"><option value="Sim" <?= ($f['fornecia_epi']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Não" <?= ($f['fornecia_epi']??'')=='Não'?'selected':'' ?>>Não</option></select></div>
                                        <div class="col-md-4"><label class="small fw-bold">EPI possuía C.A?</label><select class="form-select form-select-sm" name="ficha[epi_ca]"><option value="Sim" <?= ($f['epi_ca']??'')=='Sim'?'selected':'' ?>>Sim</option><option value="Não" <?= ($f['epi_ca']??'')=='Não'?'selected':'' ?>>Não</option></select></div>
                                        <div class="col-md-4"><label class="small fw-bold">Reposição do EPI</label><input type="text" name="ficha[reposicao_epi]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['reposicao_epi'] ?? '') ?>"></div>
                                        
                                        <div class="col-md-12"><label class="small fw-bold">Estabilidade (Gestante, CIPA, Sindicato, Acidente)</label><input type="text" name="ficha[estabilidade_desc]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['estabilidade_desc'] ?? '') ?>"></div>
                                        
                                        <div class="col-md-12 mt-3">
                                            <label class="small fw-bold d-block text-danger">Verbas Rescisórias Não Recebidas (Devidas):</label>
                                            <div class="row g-1">
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Multa Art 477" <?= in_array('Multa Art 477', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Multa Art. 477</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Aviso Prévio" <?= in_array('Aviso Prévio', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Aviso Prévio</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Saldo de Salário" <?= in_array('Saldo de Salário', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Saldo de Salário</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="13 Salário" <?= in_array('13 Salário', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">13º Salário Prop.</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Férias Proporcionais" <?= in_array('Férias Proporcionais', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Férias Prop. + 1/3</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Férias Vencidas" <?= in_array('Férias Vencidas', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Férias Vencidas</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="FGTS 40%" <?= in_array('FGTS 40%', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Multa 40% FGTS</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Horas Extras" <?= in_array('Horas Extras', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Horas Extras</label></div></div>
                                                <div class="col-md-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="ficha[verbas_devidas][]" value="Guias Seguro/TRCT" <?= in_array('Guias Seguro/TRCT', (array)($f['verbas_devidas']??[]))?'checked':'' ?>><label class="small">Guias (Seguro/TRCT)</label></div></div>
                                            </div>
                                        </div>
                                        <div class="col-md-12 mt-2"><label class="small fw-bold">O FGTS foi depositado? Período faltante:</label><input type="text" name="ficha[fgts_falta]" class="form-control form-control-sm" value="<?= htmlspecialchars($f['fgts_falta'] ?? '') ?>"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-4 text-end">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar Janela</button>
                        <button type="submit" name="editar_ficha_completa" class="btn btn-primary px-4"><i class="bi bi-save"></i> Salvar Toda Ficha</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php endforeach; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function imprimirFichaEspecífica(idFicha) {
    document.querySelectorAll('.print-only').forEach(f => f.classList.remove('print-active'));
    document.getElementById('print-ficha-' + idFicha).classList.add('print-active');
    window.print();
}
</script>
</body>
</html>